<?php

namespace App\Listeners;

use App\Services\OrderHandler;
use App\Enums\PaymentStatusEnum;
use App\Events\PaymentPied;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class PaymentPiedListener
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(PaymentPied $event): void
    {
        $event->payment->update(['status' => PaymentStatusEnum::Successful]);

        $handler = (new OrderHandler($event->payment))->handel();
    }
}
