<?php

namespace App\Livewire\Auth;

use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Validate;
use Livewire\Component;

class RegisterForm extends Component
{
    #[Validate('required')]
    public $name;

    #[Validate('required')]
    public $email;

    #[Validate('required')]
    public $phone;

    #[Validate('required')]
    public $password;

    #[Validate('required|same:password')]
    public $passwordConfirmation;

    public $identifier;

    public function mount()
    {
        $this->identifier = Session::get('login_identifier') ?? null;

        if (filter_var($this->identifier, FILTER_VALIDATE_EMAIL)) {
            $this->email = $this->identifier;
        } elseif (preg_match('/^\+?\d{10,15}$/', $this->identifier)) {
            $this->phone = $this->identifier;
        }
    }

    public function register()
    {
        $this->validate();

        $user = User::create([
            'name' => $this->name,
            'username' => $this->phone,
            'email' => $this->email,
            'phone' => $this->phone,
            'password' => Hash::make($this->password),
        ]);

        event(new Registered($user));

        $user->assignRole('client');

        Auth::login($user);

        return redirect()->route('user.dashboard');
    }

    public function render()
    {
        return view('livewire.auth.register-form');
    }
}
