<?php

namespace App\Livewire\Blesser;

use App\Models\Product;
use Livewire\Component;
use App\Models\Category;

class DesktopSearchComponent extends Component
{
    public $query = '';
    public $products = null;
    public $categories = null;
    public $showDropdown = false;

    public function updatedQuery($value)
    {

        if (strlen($value) < 2) {
            return;
        }

        $this->products = Product::where('title', 'like', '%' . $value . '%')->take(6)->get();
        $this->categories = Category::where('name', 'like', '%' . $value . '%')->take(6)->get();
        $this->showDropdown = true;
    }



    public function render()
    {
        return view('livewire.blesser.desktop-search-component');
    }
}
