<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    protected $fillable = [
        'cart_id',
        'product_id',
        'inventory_id',
        'shop_id',
        'variant',
        'price',
        'discount',
        'coupon',
        'data',
        'quantity',
    ];

    protected $with = [
        'product',
        'inventory',
        'shop',
    ];

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }

    public function product()
    {
        return $this->belongsTo(related: Product::class);
    }

    public function inventory()
    {
        return $this->belongsTo(ProductInventory::class, 'inventory_id');
    }

    public function shop()
    {
        return $this->belongsTo(Shop::class);
    }
}
