<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Traits\HasTrackingCode;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Order extends Model
{
    use HasTrackingCode;
    protected $fillable = [
        'uuid',
        'created_by_id',
        'created_by_type',
        'ordered_by_id',
        'ordered_by_type',
        'orderable_id',
        'orderable_type',
        'address_id',
        'delivery_time_id',
        'type',
        'tracking_code',
        'name',
        'phone',
        'email',
        'amount',
        'amount_with_discount',
        'discount',
        'coupon_id',
        'reseller',
        'status',
        'description',
    ];

    /**
     * The part below is for this model relationships
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(OrderItem::class);
    }

    public function deliveries(): HasMany
    {
        return $this->hasMany(Delivery::class);
    }

    public function metas(): HasMany
    {
        return $this->hasMany(OrderMeta::class);
    }

    public function payments(): MorphMany
    {
        return $this->morphMany(Payment::class, 'payable');
    }
    public function address(): BelongsTo
    {
        return $this->belongsTo(Address::class);
    }
    public function deliveryTime(): BelongsTo
    {
        return $this->belongsTo(DeliveryTime::class);
    }
    public function coupon(): BelongsTo
    {
        return $this->belongsTo(Coupon::class);
    }
    public function createdBy(): MorphTo
    {
        return $this->morphTo();
    }
    public function orderedBy(): MorphTo
    {
        return $this->morphTo();
    }
    public function orderable(): MorphTo
    {
        return $this->morphTo();
    }
    /**
     * The above is for this model relationships
     */
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $model->uuid = Str::uuid()->toString();
            $model->tracking_code = self::createTrackingCode();
        });
    }
}
