<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderReturnItem extends Model
{
    protected $fillable = [
        'order_return_id',
        'order_item_id',
        'order_reason_id',
        'quantity',
        'comments',
    ];

    /**
     * The part below is for this model relationships
     */
    public function orderReturn(): BelongsTo
    {
        return $this->belongsTo(OrderReturn::class);
    }

    public function orderItem(): BelongsTo
    {
        return $this->belongsTo(OrderItem::class);
    }

    public function orderReason(): BelongsTo
    {
        return $this->belongsTo(OrderReturnReason::class);
    }

    /**
     * The above is for this model relationships
     */
}
