<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;

class FarazSmsService
{
    protected $Soap;

    protected $fromNum = '983000505';

    protected $Patterns = [
        'activation-code' => '4nlpy0bpd8',
    ];

    private $user;

    private $pass;

    public function __construct()
    {
        $this->Soap = new \SoapClient('http://ippanel.com/class/sms/wsdlservice/server.php?wsdl');

        $this->user = env('FARAZ_SMS_USERNAME', '09120384190');
        $this->pass = env('FARAZ_SMS_PASSWORD', 'faraz24354');
        $this->fromNum = env('FARAZ_SMS_From_Number', '983000505');

        $this->Patterns['activation-code'] = env('FARAZ_SMS_PATTERN_OTP', '4nlpy0bpd8');

        Log::channel('sms')->info('data', [$this->user, $this->pass]);
    }

    /**
     * getLines
     *  get user sms panel number
     */
    public function getLines(): array
    {
        $response = $this->Soap->GetLines($this->user, $this->pass);
        $response = json_decode(json_decode($response)[1]);

        foreach ($response as $key => $value) {
            $response[$key] = json_decode($value);
        }

        return $response;
    }

    public function sendByPattern($toNum, $pattern, array $input_data)
    {
        $response = $this->Soap->sendPatternSms($this->fromNum, $toNum, $this->user, $this->pass, $this->Patterns[$pattern], $input_data);
        Log::channel('sms')->info($response);

        return $response;
    }
}
