<?php

namespace App\Services\Models;

use App\Models\User;
use App\Models\Order;
use App\Models\Coupon;
use Illuminate\Support\Collection;

class CouponService
{
    public $message;
    public $response;

    public $discount_amount = 0;

    public function checkCoupon($coupon, User $user, $total, $cart = null)
    {
        $coupon = Coupon::where('code', $coupon)->first();
        if ($coupon == null) {
            $this->message = 'The coupon dose not exist';
            $this->response = false;
            return $this;
        }

        //expire_date
        if ($coupon->expire_date < now()) {
            $this->message = 'The coupon is expired. expire date : ' . $coupon->expire_date . ' today date: ' . now() . ' |==| ' . ($coupon->expire_date < now());
            $this->response = false;
            return $this;
        }

        //minimum_spend
        if ($coupon->minimum_spend > $total) {
            $this->message = 'The minimum requirement is not met. The minimum requirement is: ' . $coupon->minimum_spend;
            $this->response = false;
            return $this;
        }

        //usage_limit
        $usage = Order::where('coupon_id', $coupon->code)->get()->count();
        if ($coupon->usage_limit < $usage) {
            $this->message = 'The coupon usage limit is met. The usage limit is: ' . $coupon->usage_limit;
            $this->response = false;
            return $this;
        }
        //usage_limit_per_user
        // $usage_per_user = Order::where('coupon', $coupon->code)->where('user_id', $user->id)->get()->count();
        // if ($coupon->usage_limit_per_user < $usage_per_user) {
        //     $this->message = 'The coupon usage limit is met for the current user. The usage limit is: ' . $coupon->usage_limit_per_user;
        //     $this->response = false;
        //     return $this;
        // }

        switch ($coupon->type) {
            case 'Percentage Discount':
                $discount = ($coupon->amount * $total)  / 100;
                $this->discount_amount = $coupon->max_discount != null && $discount > $coupon->max_discount ? $coupon->max_discount : $discount;
                break;
            case 'Fixed Cart Discount':
                $this->discount_amount = $coupon->max_discount !=  null && $coupon->amount > $coupon->max_discount ? $coupon->max_discount :  $coupon->amount;
                break;
            case 'Fixed Product Discount':
                # code...
                break;
        }

        $this->message = 'ok';
        $this->response = true;
        return $this;
    }
}
