<?php

namespace App\Services\Models;

use App\Models\Team;
use App\Models\User;
use App\Models\Order;
use App\Enums\OrderTypeEnum;
use App\Enums\OrderStatusEnum;
use Illuminate\Database\Eloquent\Model;

class OrderService
{
    public static function createOrder(User $purchaser, Model $purchasable, ?Model $creator = null, array $data = [], $items = null): Order
    {
        $defaultData = [
            'type' => $data['type'] ?? OrderTypeEnum::General,
            'name' => $purchaser->name ?? null,
            'phone' => $purchaser->phone ?? null,
            'email' => $purchaser->email ?? null,
            'amount' => 0,
            'coupon_id' => null,
            'reseller_id' => null,
            'status' => OrderStatusEnum::AwaitingPayment,
            'description' => null
        ];
        $orderData = array_merge($defaultData, $data);

        $order =  Order::create([
            'created_by_id' => $creator?->id ?? $purchaser->id,
            'created_by_type' => $creator ? get_class($creator) : get_class($purchaser),
            'ordered_by_id' => $purchaser->id,
            'ordered_by_type' => get_class($purchaser),
            'orderable_type' => get_class($purchasable),
            'orderable_id' => $purchasable->id,
            'type' => $orderData['type'],
            'name' => $orderData['name'],
            'phone' => $orderData['phone'],
            'email' => $orderData['email'],
            'amount' => $orderData['amount'],
            'coupon_id' => $orderData['coupon_id'],
            'reseller_id' => $orderData['reseller_id'],
            'status' => $orderData['status'],
            'description' => $orderData['description'],
        ]);

        if ($items) {
            foreach ($items as $key => $values) {
                $order->items()->create($values);
            }
        }
        return $order;
    }

    public static function updateOrderAmountFromItems(Order $order): Order
    {
        $order = gettype($order) == 'integer' ? Order::findOrFail($order) : $order;
        $sum = $order->items()->sum('price');
        $order->update(['amount' => $sum]);
        return $order;
    }
}
