<?php

namespace App\Services;

use App\Enums\AdvertiseStatusEnum;
use Exception;
use App\Models\Team;
use App\Models\User;
use App\Models\Order;
use App\Models\Payment;
use App\Enums\OrderTypeEnum;
use App\Enums\OrderStatusEnum;
use Illuminate\Database\Eloquent\Model;
use Spatie\FlareClient\Http\Exceptions\NotFound;
use App\Exceptions\Order\OrderCompletedException;
use App\Exceptions\Order\OrderTypeNotFoundException;

class OrderHandler
{

    private  $payment;
    private  $order; // the order itself
    private  $creator; // someone who create the order it could be the customer or admin
    private  $purchaser; // someone that order's belongs to him or her
    private  $purchasable; // the item that customer purchase can be package, subscription, advertise or deposit in wallet

    public function __construct(Payment $payment)
    {
        $this->payment  = $payment;
        $this->order  = $payment->payable;
        $this->creator  = $this->order->createdBy;
        $this->purchaser  = $this->order->orderedBy;
        $this->purchasable  = $this->order->orderable;
    }

    public function handel()
    {
        $this->validateProcess();

        $order_type = class_basename($this->purchasable);

        switch ($order_type) {
            case 'Wallet':
                $response = $this->walletOrderHandler();
                break;
            case 'Product':
                $response = $this->productOrderHandler();
                break;

            default:
                throw new OrderTypeNotFoundException("Order Type {$order_type} Not Found");
                break;
        }

        $this->markOrderAsSuccess();

        return $response;
    }


    private function walletOrderHandler(): bool
    {
        $this->purchaser->wallet->increase($this->order->amount, $this->order->description);
        return true;
    }
    private function productOrderHandler(): bool
    {
        return true;
    }



    private function markOrderAsSuccess()
    {
        $response = $this->order->update(['status' => OrderStatusEnum::Completed]);

        $this->order = Order::find($this->order->id);
    }

    private function validateProcess()
    {
        if ($this->order->status == OrderStatusEnum::Completed)
            throw new OrderCompletedException('order has already been completed');
    }
}
