<?php

namespace App\Support;

use App\Services\SweetAlert;
use Illuminate\Http\RedirectResponse;

class SweetRedirectResponse
{
    protected RedirectResponse $response;

    public function __construct(RedirectResponse $response)
    {
        $this->response = $response;
    }

    public function success(string $message, string $title = 'Success')
    {
        $this->response->with('sweetalert', SweetAlert::success(__($title), __($message)));
        return $this->response;
    }

    public function error(string $message, string $title = 'Error')
    {
        $this->response->with('sweetalert', SweetAlert::error(__($title), __($message)));
        return $this->response;
    }

    // Optionally, add warning, info, etc.
}
