<?php

namespace App\View\Components\Blesser\Element;

use Closure;
use App\Models\Product;
use Illuminate\View\Component;
use App\Enums\ProductStatusEnum;
use Illuminate\Contracts\View\View;

class ProductGrid extends Component
{
    public $title;
    public $products;
    /**
     * Create a new component instance.
     */
    public function __construct($title, $config = [])
    {
        $query = Product::where('status', ProductStatusEnum::Published);

        if (isset($config['take'])) {
            $query->take($config['take']);
        } else {
            $query->take(12);
        }

        if (isset($config['where'])) {
            foreach ($config['where'] as $column => $value) {
                $query->where($column, $value);
            }
        }

        $this->title = $title;
        $this->products = $query->get()->map(function ($product) {
            return [
                'title' => $product->title,
                'image' => $product->brand_img, // You can adjust image logic
                'url' => route('product.details', ['slug' => $product->slug]),
                'price' => $product->discount_price ?? $product->price,
                'old_price' => $product->price,
                'off_percent' => $product->off_rate

            ];
        });
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.element.product-grid');
    }
}
