<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application, which will be used when the
    | framework needs to place the application's name in a notification or
    | other UI elements where an application name needs to be displayed.
    |
    */

    'name' => env('APP_NAME', 'Laravel'),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => (bool) env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | the application so that it's available within Artisan commands.
    |
    */

    'url' => env('APP_URL', 'http://localhost'),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. The timezone
    | is set to "UTC" by default as it is suitable for most use cases.
    |
    */

    'timezone' => 'Asia/Tehran',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by Laravel's translation / localization methods. This option can be
    | set to any locale for which you plan to have translation strings.
    |
    */

    'locale' => env('APP_LOCALE', 'fa'),

    'fallback_locale' => env('APP_FALLBACK_LOCALE', 'en'),

    'faker_locale' => env('APP_FAKER_LOCALE', 'en_US'),

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is utilized by Laravel's encryption services and should be set
    | to a random, 32 character string to ensure that all encrypted values
    | are secure. You should do this prior to deploying the application.
    |
    */

    'cipher' => 'AES-256-CBC',

    'key' => env('APP_KEY'),

    'previous_keys' => [
        ...array_filter(
            explode(',', env('APP_PREVIOUS_KEYS', ''))
        ),
    ],

    /*
    |--------------------------------------------------------------------------
    | Maintenance Mode Driver
    |--------------------------------------------------------------------------
    |
    | These configuration options determine the driver used to determine and
    | manage Laravel's "maintenance mode" status. The "cache" driver will
    | allow maintenance mode to be controlled across multiple machines.
    |
    | Supported drivers: "file", "cache"
    |
    */

    'maintenance' => [
        'driver' => env('APP_MAINTENANCE_DRIVER', 'file'),
        'store' => env('APP_MAINTENANCE_STORE', 'database'),
    ],
    /*
    |--------------------------------------------------------------------------
    | App default role name
    |--------------------------------------------------------------------------
    |
    | the below roles are used in the application and can not be delete or change
    |
    |
    */

    'roles' => [
        'Administrator',
        'Admin',
        'Shop',
        'Client',
        'Developer'
    ],
    /*
    |--------------------------------------------------------------------------
    | App default permission name
    |--------------------------------------------------------------------------
    |
    | the below permissions are used in the application and can not be delete or change
    |
    |
    |
    */

    'permissions' => [
        'dashboard.view',

        'category.view',
        'category.attribute.edit',
        'category.attribute.delete',
        'category.attribute.item.view',
        'category.attribute.item.delete',

        'tag.view',
        'tag.edit',
        'tag.delete',

        'brand.view',
        'brand.edit',
        'brand.delete',

        'product.view',
        'product.view.own',
        'product.show',
        'product.edit',
        'product.delete',
        'product.add.inventory',

        'order.view',
        'order.view.own',

        'coupon.view',
        'coupon.edit',
        'coupon.delete',

        'comment.view',
        'comment.status.update',

        'post.view',
        'post.edit',
        'post.delete',

        'page.view',

        'office-equipment-group.view',
        'office-equipment-group.edit',
        'office-equipment-group.delete',

        'faq.category.view',
        'faq.category.edit',
        'faq.category.delete',

        'faq.tag.view',
        'faq.tag.edit',
        'faq.tag.delete',

        'faq.question.view',
        'faq.question.edit',
        'faq.question.delete',

        'faq.report.view',
        'faq.flag.delete',

        'file.manager.view',

        'option.panel.view',
        'option.view',

        'user.view',

        'shop.view',
        'shop.inventory.edit',
        'shop.inventory.delete',
        'shop.inventory.variant.create',
        'shop.inventory.variant.delete',
        'shop.profile.approve',
        'shop.profile.unapprove',

        'role.view',
        'permission.view',

        'import.view',
        'export.view',
        'modules.view',

        'settings.permission.edit',
        'settings.permission.delete',
        'settings.role.edit',
        'settings.role.delete',

        'settings.cache.refresh',
        'settings.cache.clear',
        'settings.cache.value',

        'footer.section.view',
        'site.status.view',
        'site.log.view',

        'component.alert.view',
        'component.tab.view',

        'delivery.view',
        'delivery.edit',
        'delivery.delete',

        'delivery.event.delete',
        'delivery.item.view',

        'delivery.day-capacity.view',
        'delivery.day-capacity.edit',
        'delivery.day-capacity.delete',

        'delivery.provider.edit',
        'delivery.provider.delete',

        'delivery.time.edit',
        'delivery.time.delete',
        'delivery.time.exception.view',

        'delivery.exceptions.edit',
        'delivery.exceptions.delete',

        'delivery.time-reservation.delete',
        'order.delivery-address.view',
    ],

];
