<?php

return [

    // سایت - عمومی
    'general' => [
        [
            'name' => 'site_name',
            'label' => 'site_name',
            'type' => 'text',
            'default' => '',
            'validation' => 'required|string|max:255',
            'items' => [],
        ],
        [
            'name' => 'site_logo',
            'label' => 'site_logo',
            'type' => 'image',
            'default' => '',
            'validation' => 'nullable|image',
            'items' => [],
        ],
        [
            'name' => 'site_logo_dark',
            'label' => 'site_logo_dark',
            'type' => 'image',
            'default' => '',
            'validation' => 'nullable|image',
            'items' => [],
        ],
        [
            'name' => 'site_favicon',
            'label' => 'site_favicon',
            'type' => 'image',
            'default' => '',
            'validation' => 'nullable|image',
            'items' => [],
        ],
        [
            'name' => 'site_description',
            'label' => 'site_description',
            'type' => 'textarea',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
        [
            'name' => 'site_tag',
            'label' => 'site_tag',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
        [
            'name' => 'site_namad',
            'label' => 'site_namad',
            'type' => 'textarea',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
    ],

    // اطلاعات تماس
    'contact' => [
        [
            'name' => 'contact_email',
            'label' => 'contact_email',
            'type' => 'email',
            'default' => '',
            'validation' => 'nullable|email',
            'items' => [],
        ],
        [
            'name' => 'contact_phone',
            'label' => 'contact_phone',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
        [
            'name' => 'address',
            'label' => 'address',
            'type' => 'textarea',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
    ],

    // تنظیمات SEO
    'seo' => [
        [
            'name' => 'meta_keywords',
            'label' => 'meta_keywords',
            'type' => 'textarea',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
        [
            'name' => 'meta_author',
            'label' => 'meta_author',
            'type' => 'text',
            'default' => 'Your Company',
            'validation' => 'nullable|string',
            'items' => [],
        ],
        [
            'name' => 'google_analytics_id',
            'label' => 'google_analytics_id',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|string',
            'items' => [],
        ],
    ],

    // شبکه‌های اجتماعی
    'social' => [
        [
            'name' => 'instagram',
            'label' => 'Instagram',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'facebook',
            'label' => 'Facebook',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'telegram',
            'label' => 'Telegram',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'whatsapp',
            'label' => 'WhatsApp',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'twitter',
            'label' => 'Twitter',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'linkedin',
            'label' => 'LinkedIn',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
        [
            'name' => 'youtube',
            'label' => 'YouTube',
            'type' => 'text',
            'default' => '',
            'validation' => 'nullable|url',
            'items' => [],
        ],
    ],

    // سیستم و نگهداری
    'system' => [
        [
            'name' => 'default_upload_disk',
            'label' => 'default_upload_disk',
            'type' => 'select',
            'default' => 'public',
            'validation' => 'required|string',
            'items' => ['local', 'public', 's3'],
        ],
        [
            'name' => 'site_language',
            'label' => 'site_language',
            'type' => 'select',
            'default' => 'fa',
            'validation' => 'required|string',
            'items' => ['fa', 'en'],
        ],
        [
            'name' => 'site_timezone',
            'label' => 'site_timezone',
            'type' => 'select',
            'default' => 'Asia/Tehran',
            'validation' => 'required|string',
            'items' => timezone_identifiers_list(),
        ],
        [
            'name' => 'enable_maintenance_mode',
            'label' => 'enable_maintenance_mode',
            'type' => 'boolean',
            'default' => false,
            'validation' => 'boolean',
            'items' => [],
        ],
        [
            'name' => 'maintenance_message',
            'label' => 'maintenance_message',
            'type' => 'textarea',
            'default' => 'در حال بروزرسانی سایت هستیم. لطفا بعداً مراجعه کنید.',
            'validation' => 'nullable|string',
            'items' => [],
        ],
    ],
];
