import { Livewire, Alpine } from '../../../vendor/livewire/livewire/dist/livewire.esm';
import Clipboard from '@ryangjchandler/alpine-clipboard'
import Swal from 'sweetalert2'
import { initFileInputs, removeImage } from './upload-input-v2';
import { initFormAjaxInputs } from './form-ajax';
import { handleBrokenImage } from '../handle-broken-image';
import '../../../node_modules/quill/dist/quill.snow.css';
import { initQuill } from '../quill-init.js';
window.app = window.app || {};
window.Swal = Swal;




const Toast = Swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.onmouseenter = Swal.stopTimer;
        toast.onmouseleave = Swal.resumeTimer;
    }
});

window.Toast = Toast;
app.toast = Toast;
app.removeImage = removeImage;
app.handleBrokenImage = handleBrokenImage;

document.addEventListener('DOMContentLoaded', function () {
    initFileInputs();
    initFormAjaxInputs();
    initQuill();
});


Alpine.plugin(Clipboard)
Livewire.start()
