@props(['post'])

<div class="border-gradient group relative rounded-[--blog-card-radius] p-px [--blog-card-radius:theme(borderRadius.2xl)] before:absolute before:-inset-px before:h-[calc(100%+2px)] before:w-[calc(100%+2px)] before:rounded-[--blog-card-radius] before:content-['']">
    <a href="{{ route('post.details' , $post->slug) }}" class="relative block overflow-hidden rounded-[calc(var(--blog-card-radius)-1px)] bg-muted">
        <div class="mb-4 bg-border p-2">
            <!-- Image -->
            <div class="overflow-hidden rounded-xl rounded-br-[50px] relative">
                <img src="{{ asset("uploads/$post->img")}}" alt="{{ $post->title }}" class="aspect-video w-full rounded-xl rounded-br-[50px] object-cover duration-500 group-hover:scale-110" />
            </div>
        </div>
        <div class="mb-4 px-2 lg:px-4">
            <p class="line-clamp-2 h-10 text-sm xs:h-12 xs:text-base">
                {{ $post->title }}
            </p>
        </div>
        <!-- Author & Date-->
        <div class="mb-4 flex items-center justify-between gap-4 px-2 lg:px-4">
            <!-- Author -->
            <div class="flex items-center gap-2 truncate">
                <div class="size-8 ">
                    <img src="/assets/themes/blesser/images/user.png" alt=" {{ $post->author  ?? $post->user->name ?? 'admin'}}" />
                </div>
                <div class="truncate text-sm">
                    {{ $post->author  ?? $post->user->name ?? 'admin'}}
                </div>
            </div>
            <!-- price -->
            <div class="min-w-fit text-sm text-primary">
                {{ is_numeric($post->price) ? number_format($post->price) : $post->price }} {{ getCurrency() }}
            </div>
        </div>
        <div class="flex items-center justify-end p-2">
            {{ $post->created_at->diffForHumans() }}
        </div>
    </a>
</div>
