@props(['categories'])

<ul class="list-group mt-2">
    @foreach($categories as $category)
    <li class="list-group-item list-hover-cat-parent">
        <div class="d-flex justify-content-between">
            <div>
                <img class="list-item-image" data-scope="category" onerror="window.app.handleBrokenImage(this)" src="{{ asset('uploads/' . $category->image) }}" alt="" style="width: 50px; aspect-ratio: 1/1; border-radius: 7px;">
                {{ $category->name }}
            </div>
            <div class="d-flex align-items-center gap-3">
                @can('product.create')
                @if($category->children->isEmpty())
                <a class="btn  btn-primary btn-sm" href="{{ route('admin.product.create', ['category_id' => $category->id]) }}">
                    {{ __('create a product') }}
                </a>
                @endif
                @endcan

                @can('category.attribute.view')
                <a class="btn  btn-primary btn-sm" href="{{ route('admin.category.attribute.index', $category->id) }}">
                    {{ __('attribute') }}
                </a>
                @endcan

                @can('category.view')
                <a class="btn  btn-info btn-sm" href="{{ route('admin.categories.show', $category->id) }}">
                    {{ __('details') }}
                </a>
                @endcan
                @can('category.edit')
                <a class="btn  btn-warning btn-sm" href="{{ route('admin.categories.edit', $category->id) }}">
                    {{ __('edit') }}
                </a>
                @endcan
                @can('category.delete')
                <form class="m-0 p-0 d-inline-block delete-form" action="{{ route('admin.categories.destroy', $category->id) }}" method="post" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this category?') ?>');">
                    @method('DELETE')
                    @csrf
                    <button class="btn  btn-danger btn-sm border-0">
                        {{ __('delete') }}
                    </button>
                </form>
                @endcan
            </div>
        </div>

        @if($category->children->isNotEmpty())
        <x-syndron.elements.category-tree :categories="$category->children" />
        @endif
    </li>
    @endforeach
</ul>
