@props(['provider' => null])

@php
$isEdit = $provider !== null;
@endphp
<div>
    <form action="{{ $isEdit ? route('admin.delivery.providers.update' , $provider->id) : route('admin.delivery.providers.store') }}" method="post">
        @csrf
        @if ($isEdit)
        @method('PATCH')
        @endif

        <div class="row">
            <!-- name -->
            <div class="mb-3 col-12">
                <label for="name" class="form-label">{{ __('name') }}</label>
                <input type="text" name="name" id="name" class="form-control" value="{{ old('name' , $provider->name ?? '') }}">
                @error('name')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- code -->
            <div class="mb-3 col-12">
                <label for="code" class="form-label">{{ __('Code') }}</label>
                <input type="text" name="code" id="code" class="form-control" value="{{ old('code' , $provider->code ?? '') }}">
                @error('code')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- contact_phone -->
            <div class="mb-3 col-12">
                <label for="contact-phone" class="form-label">{{ __('Contact Phone') }}</label>
                <input type="text" name="contact_phone" id="contact-phone" class="form-control" value="{{ old('contact_phone' , $provider->contact_phone ?? '') }}">
                @error('contact_phone')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- contact_email -->
            <div class="mb-3 col-12">
                <label for="contact-email" class="form-label">{{ __('Contact Email') }}</label>
                <input type="text" name="contact_email" id="contact-email" class="form-control" value="{{ old('contact_email' , $provider->contact_email ?? '') }}">
                @error('contact_email')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- notes -->
            <div class="mb-3 col-12">
                <label for="notes" class="form-label">{{ __('notes') }}</label>
                <input type="text" name="notes" id="notes" class="form-control" value="{{ old('notes' , $provider->notes ?? '') }}">
                @error('notes')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary ">
                    {{ __('Add a new provider') }}
                </button>
            </div>
        </div>
    </form>
</div>
