@props(['order' => null, 'users' => [], 'addresses' => [], 'deliveryTimes' => [], 'coupons' => []])

@php
    $isEdit = isset($order) && $order->exists;
    $orderStatuses = ['pending', 'processing', 'shipped', 'delivered', 'cancelled', 'refunded']; // Example statuses
    $orderTypes = ['standard', 'subscription', 'gift']; // Example types
@endphp

<form class="" action="{{ $isEdit ? route('admin.orders.update', $order) : route('admin.orders.store') }}" method="POST">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Order Name/Reference') }}</label>
                <input type="text" name="name" value="{{ old('name', $order->name ?? '') }}" class="form-control @error('name') is-invalid @enderror">
                @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Email') }}</label>
                <input type="email" name="email" value="{{ old('email', $order->email ?? '') }}" class="form-control @error('email') is-invalid @enderror">
                @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Phone') }}</label>
                <input type="text" name="phone" value="{{ old('phone', $order->phone ?? '') }}" class="form-control @error('phone') is-invalid @enderror">
                @error('phone')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Order Type') }}</label>
                <select name="type" class="form-select @error('type') is-invalid @enderror">
                    <option value="">{{ __('Select Type') }}</option>
                    @foreach($orderTypes as $type)
                        <option value="{{ $type }}" {{ old('type', $order->type ?? '') == $type ? 'selected' : '' }}>
                            {{ __(ucfirst($type)) }}
                        </option>
                    @endforeach
                </select>
                @error('type')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="mb-3">
                <label class="form-label">{{ __('Amount') }}</label>
                <input type="number" step="0.01" name="amount" value="{{ old('amount', $order->amount ?? '') }}" class="form-control @error('amount') is-invalid @enderror">
                @error('amount')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
                <label class="form-label">{{ __('Discount') }}</label>
                <input type="number" step="0.01" name="discount" value="{{ old('discount', $order->discount ?? '0.00') }}" class="form-control @error('discount') is-invalid @enderror">
                @error('discount')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
                <label class="form-label">{{ __('Amount with Discount') }}</label>
                <input type="number" step="0.01" name="amount_with_discount" value="{{ old('amount_with_discount', $order->amount_with_discount ?? '') }}" class="form-control @error('amount_with_discount') is-invalid @enderror" readonly>
                @error('amount_with_discount')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Address') }}</label>
                <select name="address_id" class="form-select @error('address_id') is-invalid @enderror">
                    <option value="">{{ __('Select Address') }}</option>
                    @foreach($addresses as $address)
                    <option value="{{ $address->id }}" {{ old('address_id', $order->address_id ?? '') == $address->id ? 'selected' : '' }}>
                        {{ $address->full_address }} {{-- Assuming Address model has a full_address accessor --}}
                    </option>
                    @endforeach
                </select>
                @error('address_id')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Delivery Time') }}</label>
                <select name="delivery_time_id" class="form-select @error('delivery_time_id') is-invalid @enderror">
                    <option value="">{{ __('Select Delivery Time') }}</option>
                    @foreach($deliveryTimes as $dt)
                    <option value="{{ $dt->id }}" {{ old('delivery_time_id', $order->delivery_time_id ?? '') == $dt->id ? 'selected' : '' }}>
                        {{ $dt->name }} {{-- Assuming DeliveryTime model has a name attribute --}}
                    </option>
                    @endforeach
                </select>
                @error('delivery_time_id')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Coupon') }}</label>
                <select name="coupon_id" class="form-select @error('coupon_id') is-invalid @enderror">
                    <option value="">{{ __('Select Coupon (Optional)') }}</option>
                    @foreach($coupons as $coupon)
                    <option value="{{ $coupon->id }}" {{ old('coupon_id', $order->coupon_id ?? '') == $coupon->id ? 'selected' : '' }}>
                        {{ $coupon->code }} - {{ $coupon->discount_amount }} {{ $coupon->type == 'percentage' ? '%' : __('Fixed') }}
                    </option>
                    @endforeach
                </select>
                @error('coupon_id')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Status') }}</label>
                <select name="status" class="form-select @error('status') is-invalid @enderror">
                    @foreach($orderStatuses as $status)
                    <option value="{{ $status }}" {{ old('status', $order->status ?? 'pending') == $status ? 'selected' : '' }}>
                        {{ __(ucfirst($status)) }}
                    </option>
                    @endforeach
                </select>
                @error('status')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Reseller') }}</label>
        <input type="text" name="reseller" value="{{ old('reseller', $order->reseller ?? '') }}" class="form-control @error('reseller') is-invalid @enderror" placeholder="{{ __('Enter reseller information if any') }}">
        @error('reseller')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Description/Notes') }}</label>
        <textarea name="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description', $order->description ?? '') }}</textarea>
        @error('description')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? __('Update') : __('Create') }} {{ __('Order') }}</button>
</form>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const amountInput = document.querySelector('input[name="amount"]');
        const discountInput = document.querySelector('input[name="discount"]');
        const amountWithDiscountInput = document.querySelector('input[name="amount_with_discount"]');

        function calculateAmountWithDiscount() {
            const amount = parseFloat(amountInput.value) || 0;
            const discount = parseFloat(discountInput.value) || 0;
            const amountWithDiscount = amount - discount;
            amountWithDiscountInput.value = amountWithDiscount >= 0 ? amountWithDiscount.toFixed(2) : '0.00';
        }

        if (amountInput && discountInput && amountWithDiscountInput) {
            amountInput.addEventListener('input', calculateAmountWithDiscount);
            discountInput.addEventListener('input', calculateAmountWithDiscount);
            // Initial calculation
            if(amountInput.value || discountInput.value){
                 calculateAmountWithDiscount();
            }
        }
    });
</script>
@endpush
