@props(['page' => null])

@php
$isEdit = isset($page) && $page->exists;
@endphp

<form action="{{ $isEdit ? route('admin.page.update', $page) : route('admin.page.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="mb-3">
        <label class="form-label">{{ __('Title') }} <span class="text-danger">(*)</span></label>
        <input type="text" name="title" value="{{ old('title', $page->title ?? '') }}" class="form-control @error('title') is-invalid @enderror">
        @error('title')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Slug') }} <span class="text-danger">(*)</span></label>
        <input type="text" name="slug" value="{{ old('slug', $page->slug ?? '') }}" class="form-control @error('slug') is-invalid @enderror">
        @error('slug')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Parent Page') }}</label>
        <select name="parent_id" class="form-select @error('parent_id') is-invalid @enderror">
            <option value="">{{ __('None') }}</option>
            @foreach(\App\Models\Page::where('id', '!=', $page->id ?? 0)->get() as $parent)
            <option value="{{ $parent->id }}" {{ old('parent_id', $page->parent_id ?? '') == $parent->id ? 'selected' : '' }}>
                {{ $parent->title }}
            </option>
            @endforeach
        </select>
        @error('parent_id')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Content') }}</label>
        <x-form.quill-editor name="content" :value="old('content', $page->content ?? '')" />
        @error('content')
        <div class="invalid-feedback d-block">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Excerpt') }}</label>
        <textarea name="excerpt" class="form-control @error('excerpt') is-invalid @enderror">{{ old('excerpt', $page->excerpt ?? '') }}</textarea>
        @error('excerpt')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Meta Title') }}</label>
        <input type="text" name="meta_title" value="{{ old('meta_title', $page->meta_title ?? '') }}" class="form-control @error('meta_title') is-invalid @enderror">
        @error('meta_title')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Meta Description') }}</label>
        <textarea name="meta_description" class="form-control @error('meta_description') is-invalid @enderror">{{ old('meta_description', $page->meta_description ?? '') }}</textarea>
        @error('meta_description')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Meta Keywords') }}</label>
        <input type="text" name="meta_keywords" value="{{ old('meta_keywords', $page->meta_keywords ?? '') }}" class="form-control @error('meta_keywords') is-invalid @enderror">
        @error('meta_keywords')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Template') }}</label>
        <input type="text" name="template" value="{{ old('template', $page->template ?? '') }}" class="form-control @error('template') is-invalid @enderror">
        @error('template')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Featured Image') }}</label>
        <input type="file" name="featured_image" class="form-control @error('featured_image') is-invalid @enderror">
        @error('featured_image')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
        @if($isEdit && $page->featured_image)
        <img src="{{ asset('storage/' . $page->featured_image) }}" class="img-thumbnail mt-2" style="max-height: 150px;">
        @endif
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Position') }}</label>
        <input type="number" name="position" value="{{ old('position', $page->position ?? '') }}" class="form-control @error('position') is-invalid @enderror">
        @error('position')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Status') }}<span class="text-danger">(*)</span></label>
        <select name="status" class="form-select @error('status') is-invalid @enderror">
            <option value="draft" {{ old('status', $page->status ?? '') == 'draft' ? 'selected' : '' }}>{{ __('Draft') }}</option>
            <option value="published" {{ old('status', $page->status ?? '') == 'published' ? 'selected' : '' }}>{{ __('Published') }}</option>
        </select>
        @error('status')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Publish Date') }}</label>
        <input type="datetime-local" name="published_at" value="{{ old('published_at', isset($page->published_at) ? $page->published_at->format('Y-m-d\TH:i') : '') }}" class="form-control @error('published_at') is-invalid @enderror">
        @error('published_at')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <button type="submit" class="btn btn-primary">{{ $isEdit ? __('Update') : __('Create') }} {{ __('Page') }}</button>
</form>
