<div>
    <div class="relative p-2">
        @session('success')
        <x-blesser.ui.alert type="success" class="m-3">
            {{ session('success') }}
        </x-blesser.ui.alert>
        @endsession
        <form wire:submit.prevent="saveComment" class="grid grid-cols-2 gap-4 md:sticky md:top-32">
            <div class="lg:text-lg">{{ __('Submit Comment') }}</div>

            <div class="col-span-2 mb-2">
                <div class="mb-4 text-sm text-text/80">
                    {{ __('Recommend this product to others') }}
                </div>
                <fieldset class="flex items-center gap-4">
                    <legend class="sr-only">{{ __('Recommendation') }}</legend>
                    <div class="w-full">
                        <input wire:model="recommendation" id="suggest-like" type="radio" name="suggest" value="1" class="peer/recommend hidden">
                        <label for="suggest-like" class="relative block cursor-pointer rounded-lg border p-2 shadow duration-200 hover:border-border/50 peer-checked/recommend:!border-success">
                            <div class="flex items-center justify-center gap-x-2 text-success">
                                <div class="i-lucide-thumbs-up size-5"></div>
                                <p class="text-sm xs:text-base">{{ __('Recommend') }}</p>
                            </div>
                        </label>
                    </div>
                    <div class="w-full">
                        <input wire:model="recommendation" id="suggest-dislike" type="radio" name="suggest" value="0" class="peer/dont-recommend hidden">
                        <label for="suggest-dislike" class="relative block cursor-pointer rounded-lg border p-2 shadow duration-200 hover:border-border/50 peer-checked/dont-recommend:!border-warning">
                            <div class="flex items-center justify-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                <p class="text-sm xs:text-base">{{ __("Don't Recommend") }}</p>
                            </div>
                        </label>
                    </div>
                </fieldset>

                @error('recommendation') <div class="text-warning h-5 text-sm">{{ $message }}</div> @enderror
            </div>
            <div class="col-span-2">
                <label for="message" class="sr-only">
                    {{ __('Comment Text') }}
                </label>
                <textarea wire:model="message" rows="3" placeholder="{{ __('Comment Text') }}" type="text" id="message" class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2"></textarea>
                @error('message') <div class="text-warning h-5 text-sm">{{ $message }}</div> @enderror
            </div>
            <div class="col-span-2">
                <x-blesser.ui.form.rate name="rate" :use_wire="true"  />
                @error('rate') <div class="text-warning h-5 text-sm">{{ $message }}</div> @enderror

            </div>

            <div class="col-span-2 flex justify-end">
                <button type="submit" class="btn-primary px-4 py-2">
                    {{ __('Submit Comment') }}
                </button>
            </div>
        </form>
    </div>
</div>
