<div class="flex-grow">
    <div class="relative">
        <div id="desktopSearchInputWrapper" class="group relative z-20 flex items-center overflow-hidden rounded-lg border bg-background pr-2 duration-150">
            <div class="i-carbon-search h-6 w-6 text-text/60"></div>
            <form action="{{ route('shop') }}" class="h-12 w-full">
                <label for="desktopSearchInput" class="sr-only">{{ __('search') }}</label>
                <input wire:model.live="query" id="desktopSearchInput" name="search" onfocus="desktopSearchFocus()" onkeyup="desktopSearchOnType(event)" type="text" placeholder="{{ __('search') }}" class="h-full w-full bg-transparent px-2 outline-none placeholder:text-sm placeholder:text-text/60 placeholder:duration-200 group-focus-within:placeholder:-translate-x-2" />
            </form>

            <button id="desktopSearchClearButton" onclick="desktopSearchClearValue()" class="ml-2 hidden h-6 w-6 items-center justify-center rounded-lg border bg-muted p-px text-text/60 duration-200 hover:border-primary hover:bg-background">
                <span class="i-lucide-x h-4 w-4"></span>
            </button>
        </div>
        <!-- Result Drop down -->
        <div id="desktopSearchResult" class="absolute left-0 top-16 z-20 hidden w-full space-y-8 rounded-lg bg-muted p-4">
            <!-- Product Result -->
            @if ($products !== null && $products->isNotEmpty())
            <div class="swiper search-result-slider">
                <div class="swiper-wrapper">
                    @foreach ($products as $product)
                    <div class="swiper-slide">
                        <a href="{{ route('product.details' , $product->slug) }}" class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                            <img src="{{ $product->brand_img }}" alt="{{ $product->title }}" class="h-20 w-20 rounded-lg object-cover" />
                            <p class="line-clamp-2 text-text/95">{{ $product->title }}</p>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Brand Result -->
            @if ($categories !== null && $categories->isNotEmpty())
            <ul class="space-y-2">
                @foreach ($categories as $category )
                <li>
                    <a href="{{ route("shop", ['category' => $category->slug]) }}" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                        {{ $category->name }}
                        <span class="i-ic-outline-arrow-outward"></span>
                    </a>
                </li>
                @endforeach

            </ul>
            @endif


            @if(false)
            <!-- Search History-->
            <div class="space-y-2">
                <div class="flex items-center gap-6">
                    <div>جستجوهای اخیر شما</div>
                    <button class="flex items-center gap-2 text-sm text-warning duration-200 hover:text-warning/80">
                        حذف همه
                        <i class="i-lucide-trash size-5"></i>
                    </button>
                </div>

                <div class="flex flex-wrap gap-4 pt-3">
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                </div>
            </div>
            <!-- Popular Search -->
            <div class="space-y-2">
                <div>جستجوهای پرتکرار</div>
                <div class="flex flex-wrap gap-4 pt-3">
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>

                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                    <a href="#" class="rounded-2xl border px-2 py-1 text-sm text-text/80 duration-200 hover:bg-background"> کفش نایک </a>
                </div>
            </div>
            @endif
        </div>
    </div>

    <div onclick="desktopSearchUnFocus()" id="desktopSearchResultOverlay" class="relative z-10 hidden">
        <div class="fixed inset-0 bg-black/40"></div>
    </div>
</div>
