<div>
    @include('livewire.partial.success-message')

    <div class="rounded-lg bg-muted shadow">
        <div class="py-5">
            <div class="mb-16 flex justify-between px-5">
                <h1 class="relative w-fit font-medium lg:text-lg">
                    اطلاعات حساب کاربری شما
                    <span class="absolute right-0 top-10 h-[3px] w-full animate-fill-border rounded-full bg-primary"></span>
                </h1>
            </div>
            <div class="grid grid-cols-2 gap-4 px-5">
                <div>
                    <label for="firstName" class="sr-only"> {{ __('First Name') }} </label>
                    <input wire:model="firstName" placeholder="{{ __('First Name') }}" type="text" id="firstName"
                           value=""
                           class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <div class="h-5 text-sm text-warning">
                        @error('firstName')
                        {{ $message }}
                        @enderror
                    </div>
                </div>
                <div>
                    <label for="lastName" class="sr-only"> {{ __('Last Name') }} </label>
                    <input wire:model="lastName" placeholder="{{ __('Last Name') }}" type="text" id="lastName" value=""
                           class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <div class="h-5 text-sm text-warning">
                        @error('lastName')
                        {{ $message }}
                        @enderror
                    </div>
                </div>

                <!-- username -->
                <div>
                    <label for="username" class="sr-only"> {{ __('Username') }} </label>
                    <input wire:model="username" placeholder="{{ __('Username') }}" type="text" id="username" value=""
                           class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <div class="h-5 text-sm text-warning">
                        @error('username')
                        {{ $message }}
                        @enderror
                    </div>
                </div>
                <!-- email -->
                <div>
                    <label for="email" class="sr-only"> {{ __('Email') }} </label>
                    <input wire:model="email" placeholder="{{ __('Email') }}" type="text" id="email" value=""
                           class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <div class="h-5 text-sm text-warning">
                        @error('email')
                        {{ $message }}
                        @enderror
                    </div>
                </div>
                <!-- phone -->
                <div>
                    <label for="phone" class="sr-only"> {{ __('Phone Number') }} </label>
                    <input wire:model="phone" placeholder="{{ __('Phone Number') }}" type="text" id="phone" value=""
                           class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <div class="h-5 text-sm text-warning">
                        @error('phone')
                        {{ $message }}
                        @enderror
                    </div>
                </div>
                <!-- password -->

            </div>
            <div class="px-5 flex justify-end">
                <button wire:click="updateUserProfile" wire:loading.attr="disabled" wire:target="updateUserProfile"
                        class="btn-primary flex items-center gap-1.5 rounded-lg px-4 py-2">
                    {{ __('Update') }}
                    <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
                </button>
            </div>
        </div>
    </div>
</div>
