@extends('layouts.syndron.app')

@section('content')
<x-syndron.breadcrumb title="{{ __('Blog') }}">
    <x-syndron.breadcrumb-item active>
        {{ __('Blog') }}
    </x-syndron.breadcrumb-item>
</x-syndron.breadcrumb>

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Posts') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.post.create') }}">
                {{ __('Create a new post') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['user_id','author','title','comment_status','slug','price','status','actions']">
            @foreach ($posts as $post )
            <tr>
                <td>{{ $post->user->name  }}</td>
                <td>{{ $post->author  }}</td>
                <td>{{ $post->title  }}</td>
                <td>{{ $post->comment_status  }}</td>
                <td>{{ $post->slug  }}</td>
                <td>{{ $post->price  }}</td>
                <td>{{ $post->status  }}</td>

                <td>
                    @if (in_array($post->name , config('app.roles')))
                    <p> {{ __('create by system') }} </p>
                    @else
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('post.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.post.edit' , $post->id) }}">{{ __('Edit') }}</a></li>
                            @endcan

                            @can('post.delete')
                            <li>
                                <form action="{{ route('admin.post.destroy' , $post->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                    @endif

                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
