@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Brands') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.brands.create') }}">
                {{ __('Create a new brand') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name', 'slug', 'category', 'actions']">
            @foreach ($brands as $brand)
            <tr>
                <td>{{ $brand->name }}</td>
                <td>{{ $brand->slug }}</td>
                <td>{{ $brand->category?->name }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('brand.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.brands.edit', $brand->id) }}">{{ __('Edit') }}</a></li>
                            @endcan
                            @can('brand.delete')
                            <li>
                                <form action="{{ route('admin.brands.destroy', $brand->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this brand?'); ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
