@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Comments') }}
            </h4>
        </div>
        <div>
            {{-- Optionally, add a button to create comments if applicable --}}
            {{-- <a class="btn btn-success" href="{{ route('admin.comments.create') }}"> --}}
            {{-- {{ __('Create a new comment') }} --}}
            {{-- </a> --}}
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name', 'content','rate', 'Status', 'Actions']">
            @foreach ($comments as $comment)
            <tr>
                <td>{{ $comment->name }}</td>
                <td>{{ Str::limit($comment->content, 50) }}</td>
                <td>
                    ({{ $comment->rate }})

                    @for ($star = 1; $star <= 5; $star++)
                        @if ($star <=$comment->rate)
                        <span style="color:#ff9e0b;">★</span>
                        @else
                        <span>★</span>
                        @endif
                        @endfor
                </td>
                <td>
                    <span class="badge bg-{{ $comment->status == \App\Enums\CommentStatusEnum::Approved ? 'success' : ($comment->status == \App\Enums\CommentStatusEnum::Pending ? 'warning' : 'danger') }}">
                        {{ __($comment->status->value) }}
                    </span>
                </td>
                <td>
                    @can('comment.status.update')
                    <form action="{{ route('admin.comments.update.status' , $comment->id) }}" method="post">
                        @csrf
                        <select name="status" id="" onchange="this.form.submit()" class="form-select ">
                            @foreach (\App\Enums\CommentStatusEnum::values() as $status)
                            <option value="{{ $status }}">{{ __($status) }}</option>
                            @endforeach
                        </select>
                    </form>
                    @endcan

                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

@endsection
