@extends('layouts.admin')

@section('content')
    <div class="container">
        <h1>{{ __('Edit Delivery Day Capacity') }}</h1>
        <form action="{{ route('admin.delivery.day-capacities.update', $delivery_day_capacity) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label for="date" class="form-label">{{ __('Date') }}</label>
                <input type="date" name="date" id="date" class="form-control" value="{{ old('date', $delivery_day_capacity->date) }}" required>
            </div>
            <div class="mb-3">
                <label for="delivery_time_id" class="form-label">{{ __('Delivery Time ID') }}</label>
                <input type="number" name="delivery_time_id" id="delivery_time_id" class="form-control" value="{{ old('delivery_time_id', $delivery_day_capacity->delivery_time_id) }}" required>
            </div>
            <div class="mb-3">
                <label for="taken" class="form-label">{{ __('Taken') }}</label>
                <input type="number" name="taken" id="taken" class="form-control" value="{{ old('taken', $delivery_day_capacity->taken) }}" required>
            </div>
            <button type="submit" class="btn btn-success">{{ __('Update') }}</button>
            <a href="{{ route('admin.delivery.day-capacities.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
        </form>
    </div>
@endsection
