@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>{{ __('Tags') }}</h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.faq.tags.create') }}">
                {{ __('Create a new tag') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name', 'slug', 'actions']">
            @foreach ($tags as $tag)
            <tr>
                <td>{{ $tag->name }}</td>
                <td>{{ $tag->slug }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('faq.tag.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.faq.tags.edit', $tag->id) }}">{{ __('Edit') }}</a>
                            </li>
                            @endcan

                            @can('faq.tag.delete')
                            <li>
                                <form action="{{ route('admin.faq.tags.destroy', $tag->id) }}" method="POST" onsubmit="return confirm('<?php echo  __('Are you sure you want to delete this tag?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

@endsection
