@extends('layouts.syndron.app')

@section('content')

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4">{{ __('Modules Management') }}</h2>
    </div>

    @if(session('status'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('status') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead class="table-light">
                <tr>
                    <th scope="col">{{ __('Feature') }}</th>
                    <th scope="col">{{ __('Status') }}</th>
                    <th scope="col" class="text-center" style="width: 120px;">{{ __('Action') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($features as $feature)
                <tr>
                    <td><code>{{ $feature }}</code></td>
                    <td>
                        @if ($statuses[$feature])
                        <span class="badge bg-success">{{ __('Enabled') }}</span>
                        @else
                        <span class="badge bg-danger">{{ __('Disabled') }}</span>
                        @endif
                    </td>
                    <td class="text-center">
                        <form method="POST" action="{{ route('admin.features.toggle', $feature) }}">
                            @csrf
                            <button type="submit" class="btn btn-sm {{ $statuses[$feature] ? 'btn-danger' : 'btn-success' }}">
                                {{ $statuses[$feature] ? __('Disable') : __('Enable') }}
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
