@extends('layouts.syndron.app')

@section('title', __('Order Details') . ' #' . $order->tracking_code)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <x-syndron.ui.card :title="__('Order Information')">
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Tracking Code') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->tracking_code }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Order UUID') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->uuid }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Customer Name') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->name }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Customer Email') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->email }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Customer Phone') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->phone }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Order Type') }}:</strong></div>
                    <div class="col-sm-8">{{ __(ucfirst($order->type)) }}</div>
                </div>
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Total Amount') }}:</strong></div>
                    <div class="col-sm-8">{{ number_format($order->amount) }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Discount') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->discount }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Final Amount') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->amount_with_discount }}</div>
                </div>
                @if($order->coupon)
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Coupon Used') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->coupon->code }}</div>
                </div>
                @endif
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Status') }}:</strong></div>
                    <div class="col-sm-8"><span class="badge bg-info">{{ __(ucfirst($order->status)) }}</span></div>
                </div>
                @if($order->reseller)
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Reseller') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->reseller }}</div>
                </div>
                @endif
                @if($order->description)
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Description/Notes') }}:</strong></div>
                    <div class="col-sm-8">{{ $order->description }}</div>
                </div>
                @endif
                <hr>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Order Date') }}:</strong></div>
                    <div class="col-sm-8">{{ verta($order->created_at)->format('F j, Y, g:i a') }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-4"><strong>{{ __('Last Updated') }}:</strong></div>
                    <div class="col-sm-8">{{ verta($order->updated_at)->format('F j, Y, g:i a') }}</div>
                </div>

                @if($order->address)
                <hr>
                <h5>{{ __('Shipping Address') }}</h5>
                <p>{{ $order->address->full_address_line_with_phone ?? $order->address->address_line_1 }}</p>
                @endif

                @if($order->deliveryTime)
                <hr>
                <h5>{{ __('Preferred Delivery Time') }}</h5>
                <p>{{ $order->deliveryTime->name }}</p>
                @endif

            </x-syndron.ui.card>

            @if($order->items->count())
            <x-syndron.ui.card :title="__('Order Items')" class="mt-4">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ __('Product') }}</th>
                                <th>{{ __('Quantity') }}</th>
                                <th>{{ __('Unit Price') }}</th>
                                <th>{{ __('Total Price') }}</th>
                                <th>{{ __('Supplier store') }}</th>
                                <th>{{ __('Product') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($order->items as $item)
                            <tr>
                                <td>{{ $item->name ?? $item->product->title ?? __('N/A') }}</td>
                                <td>{{ $item->count }}</td>
                                <td>{{ number_format($item->price) }} {{ getCurrency() }}</td>
                                <td>{{ number_format($item->count * $item->price) }} {{ getCurrency() }}</td>
                                <td>
                                    @if($item->inventory)
                                    <a href="{{ route('admin.shops.show', $item->inventory->shop_id) }}">
                                        {{ $item->inventory->seller->name }}
                                    </a>
                                    @endif
                                </td>
                                <td><a href="{{ route('admin.product.show' , $item->item_id) }}">{{ __('see product') }}</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-syndron.ui.card>
            @endif
        </div>

        <div class="col-md-4">
            <x-syndron.ui.card :title="__('Associated Data')">
                @if($order->user)
                <h6>{{ __('Registered User (Customer)') }}</h6>
                <p><a href="#">{{ $order->user->name }} ({{ $order->user->email }})</a></p>
                <hr>
                @endif

                @if($order->createdBy)
                <h6>{{ __('Created By') }}</h6>
                <p>{{ __(class_basename($order->createdBy_type)) }}: {{ $order->createdBy->name ?? $order->createdBy->id }}</p>
                <hr>
                @endif

                @if($order->orderedBy)
                <h6>{{ __('Ordered By (System)') }}</h6>
                <p>{{ __(class_basename($order->orderedBy_type)) }}: {{ $order->orderedBy->name ?? $order->orderedBy->id }}</p>
                <hr>
                @endif

                @if($order->orderable)
                <h6>{{ __('Orderable Item (e.g., Subscription)') }}</h6>
                <p>{{ __(class_basename($order->orderable_type)) }}: {{ $order->orderable->name ?? $order->orderable->id }}</p>
                <hr>
                @endif

                @if($order->deliveries->count())
                <h6>{{ __('Deliveries') }}</h6>
                <ul>
                    @foreach($order->deliveries as $delivery)
                    <li>{{ $delivery->tracking_number ?? __('Delivery') }} - {{ __(ucfirst($delivery->status)) }}</li>
                    @endforeach
                </ul>
                <hr>
                @endif

                @if($order->payments->count())
                <h6>{{ __('Payments') }}</h6>
                <ul>
                    @foreach($order->payments as $payment)
                    <li>{{ $payment->amount }} - {{ __(ucfirst($payment->status)) }} ({{ $payment->method }})</li>
                    @endforeach
                </ul>
                <hr>
                @endif

                @if($order->metas->count())
                <h6>{{ __('Order Meta') }}</h6>
                <ul>
                    @foreach($order->metas as $meta)
                    <li><strong>{{ __($meta->key) }}:</strong> {{ $meta->value }}</li>
                    @endforeach
                </ul>
                @endif
            </x-syndron.ui.card>
            <div class="mt-3">
                <a href="{{ route('admin.orders.edit', $order) }}" class="btn btn-primary">{{ __('Edit Order') }}</a>
                <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary">{{ __('Back to List') }}</a>
            </div>
        </div>
    </div>
</div>
@endsection
