@extends('layouts.syndron.app')
@section('content')
<form class="" action="{{ route('admin.product-bundle.update', $product_bundle) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')

    <div class="mb-3">
        <label class="form-label">{{ __('Name') }}</label>
        <input type="text" name="name" value="{{ old('name', $product_bundle->name) }}" class="form-control @error('name') is-invalid @enderror">
        @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Description') }}</label>
        <textarea name="description" class="form-control @error('description') is-invalid @enderror">{{ old('description', $product_bundle->description) }}</textarea>
        @error('description')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <button type="submit" class="btn btn-primary">{{ __('Update Office Equipment Group') }}</button>
</form>
@endsection
