@extends('layouts.syndron.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <h1 class="mb-4">{{ $footerSection->key }}</h1>

            <form action="{{ route('admin.settings.ui.footer-sections.update', $footerSection) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label for="value">{{ __('Title') }}</label>
                    <input type="text" name="value" class="form-control" value="{{ old('value', $footerSection->value) }}">
                </div>

                <div class="mb-3">
                    <label>{{ __('Links') }}</label>
                    <div id="links-container">
                        @php
                        $links = is_array($footerSection->data) ? $footerSection->data['links'] : json_decode($footerSection->data , true)['links'] ?? [] ;
                        @endphp
                        @foreach ($links as $i => $link)
                        <div class="row g-2 mb-2">
                            <div class="col">
                                <input type="text" name="data[links][{{ $i }}][label]" class="form-control" placeholder="Label" value="{{ $link['label'] }}">
                            </div>
                            <div class="col" dir="ltr">
                                <input type="text" name="data[links][{{ $i }}][url]" class="form-control" placeholder="URL" value="{{ $link['url'] }}">
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <button type="button" onclick="addLink()" class="btn btn-sm btn-secondary mt-2">{{ __('Add Link') }}</button>
                </div>

                <button type="submit" class="btn btn-success">{{ __('Save') }}</button>
            </form>

        </div>
    </div>
</div>

<script>
    let linkIndex = <?php echo count($links)  ?>;

    function addLink() {
        const container = document.getElementById('links-container');
        const row = document.createElement('div');
        row.classList.add('row', 'g-2', 'mb-2');
        row.innerHTML = `
            <div class="col">
                <input type="text" name="data[links][${linkIndex}][label]" class="form-control" placeholder="Label">
            </div>
            <div class="col">
                <input type="url" name="data[links][${linkIndex}][url]" class="form-control" placeholder="URL">
            </div>
        `;
        container.appendChild(row);
        linkIndex++;
    }
</script>
@endsection
