@extends('layouts.blesser.app')

@section('content')
<div class="relative">
    <div class="pointer-events-none absolute inset-0 flex items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
        <svg class="absolute left-0 top-0 h-full w-full stroke-black/20 stroke-[2] [mask-image:linear-gradient(transparent_5%,white,transparent_85%)] dark:stroke-white/20" data-n-ids="{&quot;1a4MN34vH0:0&quot;:&quot;1a4MN34vH0:0&quot;}">
            <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
            <svg>
                <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="673" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1441" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="961" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="577" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
            </svg>
            <defs>
                <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" width="96" height="96" patternUnits="userSpaceOnUse">
                    <path d="M64 0H0V64" fill="none"></path>
                </pattern>
            </defs>
        </svg>
    </div>

    <div class="container relative pt-10">


        <form action="{{ route('faq.questions.store') }}" method="post">
            @csrf
            <div class=" rounded-lg bg-muted px-4 py-6">
                @session('success')
                <div class="p-3">
                    <x-blesser.ui.alert type="" class="mb-4">{{ session('success') }}</x-blesser.ui.alert>
                </div>
                @endsession


                <div class="mb-3">
                    <x-blesser.ui.form.input name="title" label="{{ __('Question title') }}" class="" />
                    @error('title')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.select name="category_id" label="{{ __('Category') }}" :options="$categories" placeholder="{{ __('Select a category') }}" />
                    @error('category_id')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div>
                    <x-blesser.ui.form.textarea name="body" label="{{ __('Question') }}" rows="4" placeholder="{{ __('Write your question here...') }}" />
                    @error('body')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>
                <div class="flex items-center justify-end gap-4">
                    <button class="btn-primary rounded-lg px-4 py-2">
                        {{ __('Save') }}
                    </button>
                </div>
            </div>
        </form>


    </div>

</div>
@endsection
