@extends('layouts.blesser.app')

@section('content')
<section class="">
    <div class="container py-5 mb-5">
        <div class="pt-10"></div>
        <h1 class="mb-4">{{ $page->title }}</h1>

        @foreach ($page->items as $item)
        @php
        $componentClass = app('page-builder.components')->get($item->component);
        @endphp
        @if ($componentClass && class_exists($componentClass))
        {!! (new $componentClass)->render($item->settings ?? []) !!}
        @else
        <div class="alert alert-warning">Component "{{ $item->component }}" not found. {{ $componentClass }}</div>
        @endif
        @endforeach

        @if ($page->items->isEmpty())
        <div class="rounded-lg bg-muted p-5">
            {!! $page->content !!}
        </div>
        @endif

    </div>
</section>



@endsection
