@extends('layouts.blesser.app')

@section('content')
<div class="container pt-10">
    <!-- Categories -->
    @isset($_GET['category'])
    <x-blesser.element.sub-category-slider :category="$_GET['category']" />
    @endisset

    <!-- Mobile Filters -->
    <div class="flex items-center gap-4 hidden lg:hidden">
        <!-- Filter -->
        <button type="button" data-drawer-target="filter-drawer" data-drawer-show="filter-drawer" data-drawer-placement="bottom" aria-controls="filter-drawer" class="flex w-full items-center gap-2 rounded-lg bg-muted px-2 py-2">
            <div class="i-ion-ios-settings-strong size-6"></div>
            فیلتر
        </button>
        <!-- Sort -->
        <button type="button" data-drawer-target="sort-drawer" data-drawer-show="sort-drawer" data-drawer-placement="bottom" aria-controls="sort-drawer" class="flex w-full items-center gap-2 rounded-lg bg-muted px-2 py-2">
            <div class="i-lucide-list-filter size-6"></div>
            مرتب سازی
        </button>
    </div>

    <div class="grid grid-cols-12 grid-rows-[60px_min(500px,_1fr)] lg:gap-8">
        <!-- Desktop Filters -->
        <div class="col-span-12 lg:col-span-4 row-span-2 block lg:block xl:col-span-3">
            <div class="sticky top-32 mb-4 overflow-hidden rounded-lg bg-muted">
                <div dir="ltr" class="flex max-h-[calc(90vh_-_100px)] flex-col overflow-y-auto overflow-x-hidden">
                    <!-- Filters Loading Animation -->
                    <!-- <div class="animate-pulse rounded-md bg-secondary min-h-[calc(70vh_-_100px)]"></div> -->
                    <div dir="rtl">
                        <div class="flex h-full flex-col gap-4">
                            <div class="flex items-center justify-between p-4 pb-0">
                                <div class="text-lg font-medium">
                                    {{ __('filter') }}
                                </div>
                                <a href="{{ route('filter.shop.clear') }}" class="text-sm text-primary disabled:text-text/60">
                                    {{ __('clear all') }}
                                </a>
                            </div>
                            <!-- Filters -->
                            <div class="grow overflow-y-auto">
                                <ul class="divide-y">
                                    <li>
                                        <form action="{{ route('filter.shop.only.available') }}" id="only-available">
                                            <label class="flex cursor-pointer items-center justify-between px-4 py-5" for="onlyAvailableDesktop">
                                                <div>{{ __('only available product') }}</div>
                                                <div class="relative inline-flex cursor-pointer items-center">
                                                    <input name="only_available" value="true" onchange="document.getElementById('only-available').submit();" class="peer sr-only" id="onlyAvailableDesktop" type="checkbox" <?php if (session('shop.only_available') && session('shop.only_available') == 'true') echo 'checked' ?> />

                                                    <div class="peer h-6 w-11 rounded-full bg-background after:absolute after:left-[2px] after:top-0.5 after:h-5 after:w-5 after:rounded-full after:bg-muted after:transition-all after:content-[''] peer-checked:bg-primary peer-checked:after:translate-x-full"></div>
                                                </div>
                                            </label>
                                        </form>
                                    </li>
                                    <li>
                                        <form action="{{ route('filter.shop.only.special-offer') }}" id="only-only_special_offer">
                                            <label class="flex cursor-pointer items-center justify-between px-4 py-5" for="onlySpecialOfferDesktop">
                                                <div>{{ __('only  special offer') }}</div>
                                                <div class="relative inline-flex cursor-pointer items-center">
                                                    <input name="only_special_offer" value="true" onchange="document.getElementById('only-only_special_offer').submit();" class="peer sr-only" id="onlySpecialOfferDesktop" type="checkbox" <?php if (session('shop.only_special_offer') && session('shop.only_special_offer') == 'true') echo 'checked' ?> />

                                                    <div class="peer h-6 w-11 rounded-full bg-background after:absolute after:left-[2px] after:top-0.5 after:h-5 after:w-5 after:rounded-full after:bg-muted after:transition-all after:content-[''] peer-checked:bg-primary peer-checked:after:translate-x-full"></div>
                                                </div>
                                            </label>
                                        </form>
                                    </li>
                                    <li>
                                        <form action="{{ route('filter.shop.only.second-hand') }}" id="only-only_second_hand">
                                            <label class="flex cursor-pointer items-center justify-between px-4 py-5" for="onlySecondHandDesktop">
                                                <div>{{ __('only second hand') }}</div>
                                                <div class="relative inline-flex cursor-pointer items-center">
                                                    <input name="only_second_hand" value="true" onchange="document.getElementById('only-only_second_hand').submit();" class="peer sr-only" id="onlySecondHandDesktop" type="checkbox" <?php if (session('shop.only_second_hand') && session('shop.only_second_hand') == 'true') echo 'checked' ?> />

                                                    <div class="peer h-6 w-11 rounded-full bg-background after:absolute after:left-[2px] after:top-0.5 after:h-5 after:w-5 after:rounded-full after:bg-muted after:transition-all after:content-[''] peer-checked:bg-primary peer-checked:after:translate-x-full"></div>
                                                </div>
                                            </label>
                                        </form>
                                    </li>
                                    <li>
                                        <form action="{{ route('filter.shop.only.consumable') }}" id="only-only_consumable">
                                            <label class="flex cursor-pointer items-center justify-between px-4 py-5" for="onlyConsumableDesktop">
                                                <div>{{ __('only consumable') }}</div>
                                                <div class="relative inline-flex cursor-pointer items-center">
                                                    <input name="only_consumable" value="true" onchange="document.getElementById('only-only_consumable').submit();" class="peer sr-only" id="onlyConsumableDesktop" type="checkbox" <?php if (session('shop.only_consumable') && session('shop.only_consumable') == 'true') echo 'checked' ?> />
                                                    <div class="peer h-6 w-11 rounded-full bg-background after:absolute after:left-[2px] after:top-0.5 after:h-5 after:w-5 after:rounded-full after:bg-muted after:transition-all after:content-[''] peer-checked:bg-primary peer-checked:after:translate-x-full"></div>
                                                </div>
                                            </label>
                                        </form>
                                    </li>
                                    <li>
                                        <div class="relative rounded-lg bg-muted" data-accordion-item>
                                            <button type="button" class="w-full px-4 py-5 text-right md:px-6 md:py-5" data-accordion-button>
                                                <div class="flex items-center justify-between gap-2 text-sm md:text-base">
                                                    <span> {{ __('price') }} </span>
                                                    <div class="min-w-fit">
                                                        <span class="i-lucide-chevron-left duration-300" data-accordion-chevron></span>
                                                    </div>
                                                </div>
                                            </button>
                                            <div class="relative max-h-0 overflow-hidden transition-all duration-300" data-accordion-content>
                                                <form action="{{ route('filter.shop.price') }}" class="space-y-4 p-4">
                                                    <div data-id="shop-price-slider"></div>
                                                    <div class="flex items-center justify-between">
                                                        <div class="text-primary">
                                                            <span class="text-xs font-bold xl:text-sm" data-id="shop-price-slider-min"> </span>
                                                            <input type="text" name="min" hidden>
                                                            <span class="text-sm">{{ getCurrency() }}</span>
                                                        </div>
                                                        <div class="text-primary">
                                                            <span class="text-xs font-bold xl:text-sm" data-id="shop-price-slider-max"> </span>
                                                            <input type="text" name="max" hidden>
                                                            <span class="text-sm">{{ getCurrency() }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="w-full  flex justify-end">
                                                        <button type="submit" class="text-primary text-xs font-bold xl:text-sm cursor-pointer">
                                                            {{ __('apply price range') }}
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </li>

                                </ul>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-span-12 space-y-4 lg:col-span-8 xl:col-span-9">
            <!-- Desktop Sort -->
            <div class="hidden lg:block">
                <div class="flex h-14 items-center gap-x-2 rounded-lg bg-muted px-2 shadow lg:px-4">
                    <div class="flex items-center gap-x-2 text-sm lg:text-base">
                        <div class="i-lucide-list-filter size-6"></div>
                        <p>مرتب سازی بر اساس</p>
                    </div>
                    <a href="{{ route('filter.shop-order-by' , ['order_by'=> 'latest']) }}" class="rounded-lg  px-1 py-1.5 text-sm  duration-200 lg:px-4 lg:text-base <?php if (session('shop.order_by') && session('shop.order_by') == 'latest') echo 'bg-primary/15 text-primary';
                                                                                                                                                                        else echo 'hover:text-primary'; ?>">
                        {{ __('latest') }}
                    </a>
                    <a href="{{ route('filter.shop-order-by' , ['order_by'=> 'oldest']) }}" class="rounded-lg  px-1 py-1.5 text-sm  duration-200 lg:px-4 lg:text-base <?php if (session('shop.order_by') && session('shop.order_by') == 'oldest') echo 'bg-primary/15 text-primary';
                                                                                                                                                                        else echo 'hover:text-primary'; ?>">
                        {{ __('oldest') }}
                    </a>
                    <a href="{{ route('filter.shop-order-by' , ['order_by'=> 'best_seller']) }}" class="rounded-lg px-1 py-1.5 text-sm duration-200 hover:text-primary lg:px-4 lg:text-base <?php if (session('shop.order_by') && session('shop.order_by') == 'best_seller') echo 'bg-primary/15 text-primary';
                                                                                                                                                                                            else echo 'hover:text-primary'; ?>">
                        {{ __('best seller') }}
                    </a>
                    <a href="{{ route('filter.shop-order-by' , ['order_by'=> 'most_expensive']) }}" class="rounded-lg px-1 py-1.5 text-sm duration-200 hover:text-primary lg:px-4 lg:text-base <?php if (session('shop.order_by') && session('shop.order_by') == 'most_expensive') echo 'bg-primary/15 text-primary';
                                                                                                                                                                                                else echo 'hover:text-primary'; ?>">
                        {{ __('most expensive') }}
                    </a>
                    <a href="{{ route('filter.shop-order-by' , ['order_by'=> 'cheapest']) }}"
                        class="rounded-lg px-1 py-1.5 text-sm duration-200 hover:text-primary lg:px-4 lg:text-base <?php if (session('shop.order_by') && session('shop.order_by') == 'cheapest') echo 'bg-primary/15 text-primary';
                                                                                                                    else echo 'hover:text-primary'; ?>">
                        {{ __('cheapest') }}
                    </a>
                </div>
            </div>


            <div class="grid grid-cols-2 gap-2 gap-y-2 xs:gap-4 sm:grid-cols-3 lg:grid-cols-3 xl:grid-cols-4">
                <!-- Search Result -->

                @forelse ($products as $product )
                <x-blesser.element.single-product-card :product="$product" />
                @empty
                <!-- Empty Search Result -->
                <div class="w-full flex flex-col gap-y-4 items-center justify-center text-text col-span-4">
                    <div class="i-ic-outline-search-off size-24"></div>
                    <div class="text-2xl">
                        {{ __('we couldn\'t find product') }}
                    </div>
                </div>
                @endforelse

            </div>
            <!-- Pagination -->
            {{ $products->links('pagination.blesser') }}
        </div>
    </div>
</div>

@endsection
