@if ($paginator->hasPages())
    <div class="flex items-center justify-center gap-1">

        {{-- First Page --}}
        <a href="{{ $paginator->url(1) }}" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="First Page" @if ($paginator->onFirstPage()) disabled @endif>
            <i class="i-lucide-chevrons-right"></i>
        </a>

        {{-- Previous Page --}}
        <a href="{{ $paginator->previousPageUrl() }}" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Previous Page" @if (!$paginator->previousPageUrl()) disabled @endif>
            <i class="i-lucide-chevron-right"></i>
        </a>

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <div class="flex h-9 w-9 items-center justify-center">
                    <i class="i-lucide-ellipsis text-text/80"></i>
                </div>
            @endif

            {{-- Page Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    <a href="{{ $url }}" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border {{ $page == $paginator->currentPage() ? 'border-primary-btn bg-primary-btn text-white' : 'bg-muted hover:bg-secondary' }} p-0 text-sm font-medium">
                        {{ $page }}
                    </a>
                @endforeach
            @endif
        @endforeach

        {{-- Next Page --}}
        <a href="{{ $paginator->nextPageUrl() }}" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Next Page" @if (!$paginator->nextPageUrl()) disabled @endif>
            <i class="i-lucide-chevron-left"></i>
        </a>

        {{-- Last Page --}}
        <a href="{{ $paginator->url($paginator->lastPage()) }}" class="inline-flex h-10 w-10 items-center justify-center whitespace-nowrap rounded-md border bg-muted p-0 text-sm font-medium hover:bg-secondary disabled:opacity-50" aria-label="Last Page" @if ($paginator->currentPage() == $paginator->lastPage()) disabled @endif>
            <i class="i-lucide-chevrons-left"></i>
        </a>
    </div>
@endif
