<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Delivery\DeliveryController;
use App\Http\Controllers\Admin\Delivery\DeliveryItemController;
use App\Http\Controllers\Admin\Delivery\DeliveryTimeController;
use App\Http\Controllers\Admin\Delivery\DeliveryEventController;
use App\Http\Controllers\Admin\Delivery\DeliveryProviderController;
use App\Http\Controllers\Admin\Delivery\DeliveryDayCapacityController;
use App\Http\Controllers\Admin\Delivery\OrderDeliveryAddressController;
use App\Http\Controllers\Admin\Delivery\DeliveryTimeExceptionController;
use App\Http\Controllers\Admin\Delivery\DeliveryTimeReservationController;

/**
 * please register all your routes inside the group not outside
 */
Route::prefix('delivery')->name('delivery.')->group(function () {
    Route::get('/up', function () {
        return 'admin delivery route group is active';
    });



    // 1. Carriers / Providers
    Route::resource('providers', DeliveryProviderController::class)
        ->except(['show']);

    // 2. Time Slots (weekly)
    Route::resource('times', DeliveryTimeController::class);

    // 2.1 Exceptions (nested under delivery-times)
    Route::resource(
        'time.exceptions',
        DeliveryTimeExceptionController::class
    )->shallow();

    // 3. Optional: Day capacity cache (read-only / cleanup)
    Route::resource(
        'day-capacities',
        DeliveryDayCapacityController::class
    )->only(['index', 'show', 'destroy']);

    // 4. Reservations (monitor / manually clear holds)
    Route::resource(
        'time-reservations',
        DeliveryTimeReservationController::class
    )->only(['index', 'destroy']);

    // 5. Deliveries
    Route::resource('deliveries', DeliveryController::class)
        ->only(['index', 'show', 'edit', 'update', 'destroy']);

    // 5.1 Events (read-only / delete only)
    Route::resource(
        'deliveries.delivery-events',
        DeliveryEventController::class
    )->only(['index', 'destroy']);

    // 6. Delivery Items (if you need to re‐assign items)
    Route::resource('items', DeliveryItemController::class)
        ->only(['index', 'edit', 'update']);

    // 7. Archived order addresses (read-only)
    Route::resource(
        'order-delivery-addresses',
        OrderDeliveryAddressController::class
    )->only(['index', 'show']);
});
