<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class AnswerUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'body' => ['sometimes', 'string', 'min:3', 'max:1000'],
            'is_best_answer' => ['sometimes', 'boolean'],
        ];
    }
}
