<?php

namespace Artemis\Faq\Http\Resources;

use Artemis\Faq\Models\Flag;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Flag */
class FlagResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'flagged_by' => $this->user_id,
            'flaggable_id' => $this->flaggable_id,
            'flaggable_type' => class_basename($this->flaggable_type),
            'reason' => $this->reason,
            'flagged_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
