<?php

namespace Artemis\Faq\Models;

use App\Models\User;
use Artemis\Faq\Traits\Votable;
use Artemis\Faq\Traits\HasTablePrefix;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Comment extends Model
{
    use SoftDeletes, Votable, HasTablePrefix;

    protected $fillable = [
        'user_id',
        'body',
        'commentable_id',
        'commentable_type',

    ];

    public function commentable(): MorphTo
    {
        return $this->morphTo();
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
