<?php

namespace Artemis\Faq\Rules;

use Str;
use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Contracts\Validation\ValidationRule;

class isUniqueSlugRule implements ValidationRule
{
    public function __construct(
        protected string|Model $model,
        protected string $column = 'slug',
    ) {
        if (is_string($this->model)) {
            $this->model = new $this->model;
        }
    }
    
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $slug = Str::slug($value);
        
        if ($this->model::where($this->column, $slug)->exists()) {
            $fail("Slug '$slug' is already taken.");
        }
    }
}
