<?php

namespace Artemis\Faq\Traits;

use Response;
use Illuminate\Http\JsonResponse;

trait ApiResponder
{
    public function response(mixed $data, string $message, int $status): JsonResponse
    {
        return Response::json([
            'status' => $status,
            'message' => $message,
            'data' => $data,
        ], $status);
    }
    
    public function success(mixed $data = null, ?string $message = null, int $status = 200): JsonResponse
    {
        return $this->response($data, $message ?? __('api.success'), $status);
    }
    
    public function failure(mixed $data = null, ?string $message = null, int $status = 500): JsonResponse
    {
        return $this->response($data, $message ?? __('api.server_error'), $status);
    }
}